import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import DisplaysIdentityViewer from "identity-editor-elements/src/displays/templates/IdentityViewer";
import DisplaysIdentityDialog from "identity-editor-elements/src/displays/templates/IdentityDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractProfileEditor extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock format="air" layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1479262271" visible={false} layout="vertical flexible centercenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_905870609" format="h5" mode="normal" value="Profile not found. Contact with administrator.">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267" visible={false} layout="vertical flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a433175005" format="center" layout="vertical" width="70.0%" height="100.0%">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a142686109" layout="horizontal">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a232500404" title="Edit identity" target="self" mode="MaterialIconButton" icon="Create" size="Small" format="airRight">
							</UiOpenDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a490762359" layout="vertical flexible">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2073866567" layout="vertical flexible" width="100.0%" height="100.0%">
								<DisplaysIdentityViewer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1163307876">
								</DisplaysIdentityViewer>
							</UiBlock>
						</UiBlock>
						<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a287486439" title="Edit profile">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_310303471" format="minWidth" layout="vertical flexible" width="550px" height="-1px">
								<DisplaysIdentityDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_757518282">
								</DisplaysIdentityDialog>
							</UiBlock>
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1043648094">
							</UiDivider>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1005869525" layout="horizontal endjustified">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a632898918" title="Cancel" target="self" mode="Button" size="Medium" format="airRight">
								</UiAction>
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a577162228" title="Accept" target="self" mode="Button" size="Medium" highlighted="Fill">
								</UiAction>
							</UiBlock>
						</UiDialog>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}