import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysPropertyEditor from "identity-editor-elements/src/displays/templates/PropertyEditor";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractIdentityEditor extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_388539990" visible={false} layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a748869504" mode="Rise">
					</UiSpinner>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1031376643" format="airTop" visible={false} layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1541224035" layout="vertical flexible">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311108272" multiple={{instances:"propertiesStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}