import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import DisplaysHeader from "identity-editor-elements/src/displays/templates/Header";
import DisplaysTeamEditor from "identity-editor-elements/src/displays/templates/TeamEditor";
import DisplaysProfileEditor from "identity-editor-elements/src/displays/templates/ProfileEditor";
import DisplaysFooter from "identity-editor-elements/src/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractHomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="UI_12_1_01655907337" layout="vertical" width="100.0%" height="100.0%">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="UI_13_2_0929523249" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="UI_14_3_0994118078">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="teamEditorPage" layout="vertical flexible">
						<DisplaysTeamEditor context={this._context.bind(this)} owner={this._owner.bind(this)} id="teamEditorStamp">
						</DisplaysTeamEditor>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="profileEditorPage" layout="vertical flexible">
						<DisplaysProfileEditor context={this._context.bind(this)} owner={this._owner.bind(this)} id="profileEditorStamp">
						</DisplaysProfileEditor>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="UI_19_2_1211979999" layout="vertical">
						<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="UI_19_10_1481191824">
						</DisplaysFooter>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}