import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractPropertyViewer from "../../../gen/displays/templates/AbstractPropertyViewer";
import PropertyViewerNotifier from "../../../gen/displays/notifiers/PropertyViewerNotifier";
import PropertyViewerRequester from "../../../gen/displays/requesters/PropertyViewerRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PropertyViewer extends AbstractPropertyViewer {

	constructor(props) {
		super(props);
		this.notifier = new PropertyViewerNotifier(this);
		this.requester = new PropertyViewerRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(PropertyViewer));
DisplayFactory.register("PropertyViewer", withStyles(styles, { withTheme: true })(withSnackbar(PropertyViewer)));