import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractProfileTemplate from "../../../gen/displays/templates/AbstractProfileTemplate";
import ProfileTemplateNotifier from "../../../gen/displays/notifiers/ProfileTemplateNotifier";
import ProfileTemplateRequester from "../../../gen/displays/requesters/ProfileTemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ProfileTemplate extends AbstractProfileTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ProfileTemplateNotifier(this);
		this.requester = new ProfileTemplateRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ProfileTemplate));
DisplayFactory.register("ProfileTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ProfileTemplate)));