import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractProfileEditor from "../../../gen/displays/templates/AbstractProfileEditor";
import ProfileEditorNotifier from "../../../gen/displays/notifiers/ProfileEditorNotifier";
import ProfileEditorRequester from "../../../gen/displays/requesters/ProfileEditorRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ProfileEditor extends AbstractProfileEditor {

	constructor(props) {
		super(props);
		this.notifier = new ProfileEditorNotifier(this);
		this.requester = new ProfileEditorRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ProfileEditor));
DisplayFactory.register("ProfileEditor", withStyles(styles, { withTheme: true })(withSnackbar(ProfileEditor)));