import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractIdentityViewer from "../../../gen/displays/templates/AbstractIdentityViewer";
import IdentityViewerNotifier from "../../../gen/displays/notifiers/IdentityViewerNotifier";
import IdentityViewerRequester from "../../../gen/displays/requesters/IdentityViewerRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class IdentityViewer extends AbstractIdentityViewer {

	constructor(props) {
		super(props);
		this.notifier = new IdentityViewerNotifier(this);
		this.requester = new IdentityViewerRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(IdentityViewer));
DisplayFactory.register("IdentityViewer", withStyles(styles, { withTheme: true })(withSnackbar(IdentityViewer)));