import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractIdentityEditor from "../../../gen/displays/templates/AbstractIdentityEditor";
import IdentityEditorNotifier from "../../../gen/displays/notifiers/IdentityEditorNotifier";
import IdentityEditorRequester from "../../../gen/displays/requesters/IdentityEditorRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class IdentityEditor extends AbstractIdentityEditor {

	constructor(props) {
		super(props);
		this.notifier = new IdentityEditorNotifier(this);
		this.requester = new IdentityEditorRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(IdentityEditor));
DisplayFactory.register("IdentityEditor", withStyles(styles, { withTheme: true })(withSnackbar(IdentityEditor)));