import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractErrorTemplate from "../../../gen/displays/templates/AbstractErrorTemplate";
import ErrorTemplateNotifier from "../../../gen/displays/notifiers/ErrorTemplateNotifier";
import ErrorTemplateRequester from "../../../gen/displays/requesters/ErrorTemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ErrorTemplate extends AbstractErrorTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ErrorTemplateNotifier(this);
		this.requester = new ErrorTemplateRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ErrorTemplate));
DisplayFactory.register("ErrorTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ErrorTemplate)));