import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractDefinitionViewer from "../../../gen/displays/templates/AbstractDefinitionViewer";
import DefinitionViewerNotifier from "../../../gen/displays/notifiers/DefinitionViewerNotifier";
import DefinitionViewerRequester from "../../../gen/displays/requesters/DefinitionViewerRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DefinitionViewer extends AbstractDefinitionViewer {

	constructor(props) {
		super(props);
		this.notifier = new DefinitionViewerNotifier(this);
		this.requester = new DefinitionViewerRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DefinitionViewer));
DisplayFactory.register("DefinitionViewer", withStyles(styles, { withTheme: true })(withSnackbar(DefinitionViewer)));