import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import DisplaysIdentityViewer from "identity-editor-elements/src/displays/templates/IdentityViewer";
import DisplaysIdentityDialog from "identity-editor-elements/src/displays/templates/IdentityDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractTeamEditor extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock format="air" layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_142276588" visible={false} layout="vertical flexible centercenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1511587059" format="h5" mode="normal" value="Identities file not found. Check your configuration.">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009" visible={false} layout="vertical flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a854129165" layout="horizontal">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1808003305" title="Previous identity" target="self" mode="MaterialIconButton" icon="NavigateBefore" size="Small" format="airRight">
						</UiAction>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a356551141" title="Next identity" target="self" mode="MaterialIconButton" icon="NavigateNext" size="Small" format="airRight">
						</UiAction>
						<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1676165539" title="Add identity" target="self" mode="MaterialIconButton" icon="Add" size="Small" format="airRight">
						</UiOpenDialog>
						<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1417471932" title="Edit identity" target="self" mode="MaterialIconButton" icon="Create" size="Small" format="airRight">
						</UiOpenDialog>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_809275366" mode="normal" placeholder="Search identity...">
						</UiTextEditable>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1286215103" layout="vertical flexible">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_56520036" layout="vertical flexible" width="100.0%" height="100.0%">
							<DisplaysIdentityViewer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1242277703">
							</DisplaysIdentityViewer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1853177423" format="middleAirTop" layout="horizontal">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1470533774" layout="vertical flexible">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1875645853" mode="normal">
								</UiText>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a441329751" title="Edit identity">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a36582561" format="minWidth" layout="vertical flexible" width="550px" height="-1px">
							<DisplaysIdentityDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a836140710">
							</DisplaysIdentityDialog>
						</UiBlock>
						<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_634150863">
						</UiDivider>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314354476" layout="horizontal endjustified">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1877117277" title="Cancel" target="self" mode="Button" size="Medium" format="airRight">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1821380587" title="Accept" target="self" mode="Button" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
					</UiDialog>
				</UiBlock>
			</UiBlock>
		);
	}
}