import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiUser from "alexandria-ui-elements/src/displays/components/User";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractHeader extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="horizontal center" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_933421996" layout="horizontal center flexible" spacing="8">
					<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1023112829" width="200px" height="50px">
					</UiImage>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1683245888" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_695338815" format="h2" mode="normal" value="Identities">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_401772273" format="h5 grey" visible={false} mode="normal" value="slogan">
						</UiText>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_322613064" format="h6 secondary" layout="horizontal center endjustified" spacing="16">
					<UiUser context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1978537138" color="grey" mode="PhotoWithFullname">
					</UiUser>
				</UiBlock>
			</UiBlock>
		);
	}
}