import React from "react";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractErrorTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1515050422" format="backgroundLogin">
				</UiImage>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1061767175" format="grey" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1888874542" format="visible" layout="vertical" width="400px" height="200px" paper>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1417646513" format="relative" layout="vertical flexible centerjustified" width="100.0%" height="100.0%" spacing="16">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_467522036" layout="vertical centercenter">
								<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a999847991">
								</UiImage>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1629997833" format="h4 airTop" mode="normal">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a472718344" layout="vertical">
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1964282056">
							</UiDivider>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1421313708" title="Logout" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}