import { createMuiTheme } from '@material-ui/core/styles';

const Theme = (function () {
	var theme = null;
	var provider = {
		create: () => {
			theme = createMuiTheme({
				palette : {
				    primary : { main: "#005b9f" },
				    secondary : { main: "#ff9100" },
				    error : { main: "#f44336" },
				    contrastThreshold : "3",
				    tonalOffset : "0.2",
				    grey : {
				    	primary: "#888",
				    	secondary: '#ddd'
				    }
				},
				typography : {
				    fontFamily : '"-apple-system","BlinkMacSystemFont","Segoe UI","Roboto","Helvetica Neue","Arial","sans-serif","Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol"',
				    fontSize : 13,
				    useNextVariants: true
				},
				formats: {
				    h1: { color:'#05673c',textShadow:'2px 2px 2px #fff',fontSize:'25pt' },
				    h2: { color:'#05673c',textShadow:'2px 2px 2px #fff',fontSize:'20pt' },
				    h3: { fontSize:'15pt' },
				    h4: { fontSize:'14pt',fontWeight:'400' },
				    h5: { fontSize:'12pt' },
				    h6: { lineHeight:'17pt',fontSize:'12pt' },
				    body1: {  },
				    body2: {  },
				    subtitle1: {  },
				    subtitle2: {  },
				    block: { padding:'10px',position:'relative',border:'1px solid #efefef',borderRadius:'5px',background:'white' },
				    blockRemoveIcon: { position:'absolute',top:0,right:0,marginTop:'-10px',marginRight:'-7px',zIndex:1,background:'white',border:'1px solid #efefef' },
				    dialog: { padding:'10px',margin:'10px' },
				    link: { color:'#ff9100' },
				    secondary: {  },
				    highlightedBlock: { background:'white',padding:'10px',borderRadius:'10px' },
				    secondaryHighlighted: { color:'#ff9100',borderBottom:'1px solid white' },
				    separator: { borderBottom:'1px solid #ddd',width:'100%' },
				    rightSeparator: { borderRight:'1px solid black' },
				    main: { minHeight:'100%' },
				    footerFormat: { background:'#efefef',padding:'10px 30px',borderTop:'1px solid #aaa' },
				    headerSubtitle: { color:'white',position:'absolute',top:0,left:0,marginLeft:'180px',marginTop:'6px',textTransform:'uppercase',fontSize:'9pt' },
				    whiteBackground: { background:'white',borderRadius:'3px',height:'100%',border:'1px solid #efefef' },
				    air: { padding:'10px 20px' },
				    airHeader: { padding:'4px 20px' },
				    userHeader: { marginTop:'10px',paddingBottom:'10px',borderBottom:'1px solid #ddd' },
				    toolbar: { margin:'5px 0px 20px' },
				    airTop: { marginTop:'10px' },
				    doubleAirTop: { marginTop:'20px' },
				    middleAirTop: { marginTop:'5px' },
				    middleAirRight: { marginRight:'5px' },
				    airBottom: { marginBottom:'10px' },
				    middleAirBottom: { marginBottom:'5px' },
				    doubleAirBottom: { marginBottom:'20px' },
				    doubleAirLeft: { marginLeft:'20px' },
				    airLeft: { marginLeft:'10px' },
				    middleAirLeft: { marginLeft:'5px' },
				    airTagsLeft: { marginLeft:'3px' },
				    airRight: { marginRight:'10px' },
				    airMenuRight: { marginRight:'4px' },
				    containerAirMedium: { padding:'10px' },
				    containerAirLarge: { padding:'20px' },
				    filled: { background:'#efefef',padding:'8px',minHeight:'300px' },
				    filledNoAir: { background:'#efefef',minHeight:'200px' },
				    filledNoAirLarge: { background:'#efefef',minHeight:'400px' },
				    headerToolbar: { marginTop:'10px' },
				    textCentered: { textAlign:'center' },
				    center: { margin:'0 auto' },
				    autoHeight: { height:'auto' },
				    facetsAbsolute: { color:'#888',fontSize:'10px',marginTop:'-10px',position:'absolute' },
				    valuesLabelFormat: { whiteSpace:'nowrap' },
				    bordered: { border:'1px solid #efefef',width:'100%' },
				    paperFormat: { minHeight:'300px' },
				    underline: { borderBottom:'1px dotted #ddd',width:'100%',marginBottom:'10px' },
				    description: { fontSize:'10pt',color:'grey' },
				    propertyError: { fontSize:'10pt',color:'#b60200' },
				    minHeight: { minHeight:'100%' },
				    minWidth: { minWidth:'400px' },
				    minPhotoWidth: { minWidth:'100px' },
				    usersStampFormat: { height:'100%' },
				    relative: { position:'relative' },
				    contentCopyDashboardIcon: { position:'absolute',right:'44px',top:'-12px',background:'white',border:'1px solid #efefef' },
				    removeDashboardIcon: { position:'absolute',right:'-12px',top:'-12px',background:'white',border:'1px solid #efefef' },
				    thesaurus: { overflow:'auto',padding:'10px',minWidth:'300px',minHeight:'400px' },
				    grey: { background:'#efefef' },
				    loginError: { position:'absolute',bottom:'-10px',textAlign:'center',width:'100%',color:'red' },
				    backgroundLogin: { position:'absolute',bottom:'0',top:'0',width:'100%',height:'100%',zIndex:'0' },
				    logoLogin: { filter:'brightness(0) invert(1)',position:'absolute',margin:'30px' },
				    visible: { zIndex:'1' },
				    openUsersButton: { width:'150px' },
				    userNotGranted: { fontSize:'20pt',textAlign:'center',marginTop:'40px' },
				    moduleAir: { padding:'10px 20px' },
				    estadoFormat: { margin:'5px 2px' },
				    editandoFormat: { margin:'0 8px 6px 0' },
				    absolute: { position:'absolute' },
				    propertyValue: { wordBreak:'break-all' },
				    propertyImageTypeSize: { height:'200px',width:'150px' },
				    propertyViewerStyle: { display:'block' },
				    propertyImageView: { border:'1px solid #efefef' },
				    cardTitle: { textAlign:'left',color:'#B71A1C',padding:'10px' },
				    cardContent: { textAlign:'left',padding:'10px' }
				}
			});
			return theme;
		},
		get: () => {
			return theme;
		},
	};
	return provider;
})();

export default Theme;