/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRepository;
import io.intino.alexandria.ui.displays.DisplayRouter;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.ProxyResource;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.ui.pages.PropertyViewerProxyPage;
import java.util.function.Function;

public class PropertyViewerProxyResource
extends ProxyResource {
    private final IdentityEditorBox box;

    public PropertyViewerProxyResource(IdentityEditorBox box, UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    public void execute() throws AlexandriaException {
        this.fillBrowser(this.manager, this.session());
        this.fillDeviceParameter();
        try {
            if (!this.isLogged(this.accessToken())) {
                throw new Unauthorized("user is not logged");
            }
            this.authenticate(this.session(), this.accessToken());
            this.render();
        }
        catch (CouldNotObtainInfo couldNotObtainInfo) {
            throw new Unauthorized("user is not logged");
        }
        catch (Throwable error) {
            throw new Unauthorized("could not render component");
        }
    }

    private void render() {
        final UIClient client = this.client();
        final PropertyViewerProxyPage page = new PropertyViewerProxyPage();
        page.session = this.session();
        page.session.browser().onRedirect(location -> this.manager.redirect(location));
        page.session.browser().requestUrl(this.manager.requestUrl());
        page.session.whenLogin((Function)new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return PropertyViewerProxyResource.this.authenticate(page.session, baseUrl);
            }
        });
        page.session.whenLogout(b -> this.logout(page.session));
        page.box = this.box;
        page.clientId = client.id();
        page.googleApiKey = "";
        page.device = this.parameterValue("device");
        page.personifiedDisplay = this.parameterValue("personifiedDisplay");
        if (!page.hasPermissions()) {
            this.manager.redirect(page.redirectUrl());
            return;
        }
        Soul soul = this.soul();
        if (soul != null) {
            page.soul = soul;
            page.execute();
            return;
        }
        soul = new Soul(page.session){

            public void personify() {
                2 soul = this;
                this.addRegisterDisplayListener(display -> {
                    display.inject(PropertyViewerProxyResource.this.notifier(page2.session, client, display));
                    display.inject(page2.session);
                    display.inject((DisplayRepository)soul);
                    display.inject(() -> soul);
                });
            }
        };
        client.soul(soul);
        page.soul = soul;
        page.execute();
        this.box.registerSoul(client.id(), soul);
        soul.register(new DisplayRouter((AlexandriaUiBox)this.box).id("__router__"));
        this.manager.write((Object)"OK");
    }
}

