/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.amidas.identityeditor.box.ContextManager;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractTeamEditor;
import io.intino.amidas.shared.Team;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class TeamEditor
extends AbstractTeamEditor<Box> {
    private Team team;
    private String condition;
    private int current = 0;
    private List<Team.Identity> identities = Collections.emptyList();
    private Consumer<Team> modifiedListener;
    private Consumer<Team.Identity> identityModifiedListener;

    public TeamEditor(Box box) {
        super(box);
    }

    public TeamEditor team(Team team) {
        this.team = team;
        return this;
    }

    public TeamEditor onModify(Consumer<Team> listener) {
        this.modifiedListener = listener;
        return this;
    }

    public TeamEditor onModifyIdentity(Consumer<Team.Identity> listener) {
        this.identityModifiedListener = listener;
        return this;
    }

    public void filter(String condition) {
        this.condition = condition;
        this.identities = this.team != null ? this.team.search(condition) : Collections.emptyList();
        this.current = 0;
    }

    @Override
    public void init() {
        super.init();
        this.initToolbar();
        this.initDialog();
    }

    private void initToolbar() {
        this.search.onChange(e -> {
            this.filter((String)e.value());
            this.refresh();
        });
        this.search.onEnterPress(e -> this.filter());
        this.previous.onExecute(e -> this.previous());
        this.next.onExecute(e -> this.next());
    }

    private void initDialog() {
        this.openAddIdentity.onOpen(e -> {
            this.identityDialogBox.title(this.translate("Add identity"));
            this.identityDialogBox.main.dialog.properties(this.team.grammar().getAll());
            this.identityDialogBox.main.dialog.identity(this.createIdentity());
            this.identityDialogBox.main.dialog.refresh();
        });
        this.openEditIdentity.onOpen(e -> {
            this.identityDialogBox.title(this.translate("Edit identity"));
            this.identityDialogBox.main.dialog.properties(this.team.grammar().getAll());
            this.identityDialogBox.main.dialog.identity(this.current());
            this.identityDialogBox.main.dialog.refresh();
        });
        this.cancel.onExecute(e -> this.identityDialogBox.close());
        this.accept.onExecute(e -> this.saveIdentity());
    }

    private Team.Identity createIdentity() {
        return this.team.createIdentity();
    }

    private void removeIdentity() {
        ContextManager.register(this.soul());
        this.notifyUser(this.translate("Identity removed"), UserMessage.Type.Success);
        this.notifySaveIdentities();
        this.previous();
    }

    private void saveIdentity() {
        this.identityDialogBox.close();
        ContextManager.register(this.soul());
        this.notifyUser(this.translate("Identity saved"), UserMessage.Type.Success);
        this.notifySave(this.identityDialogBox.main.dialog.identity());
        this.refreshIdentity(this.identityDialogBox.main.dialog.identity());
    }

    private void notifySaveIdentities() {
        if (this.modifiedListener != null) {
            this.modifiedListener.accept(this.team);
        }
    }

    private void notifySave(Team.Identity identity) {
        this.notifySaveIdentities();
        if (this.identityModifiedListener != null) {
            this.identityModifiedListener.accept(identity);
        }
    }

    public void reloadTeam(Team team) {
        this.team = team;
        this.identities = team.search(this.condition);
        this.updateIdentity();
        this.refresh();
    }

    private void updateIdentity() {
        Team.Identity identity = this.identityDialogBox.main.dialog.identity();
        if (identity == null) {
            return;
        }
        int pos = this.findIdentity(identity);
        this.current = pos != -1 ? pos : 0;
    }

    private int findIdentity(Team.Identity identity) {
        for (int i = 0; i < this.identities.size(); ++i) {
            if (!this.identities.get(i).id().equals(identity.id())) continue;
            return i;
        }
        return -1;
    }

    public void refresh() {
        super.refresh();
        this.refreshLayers();
        if (this.team == null) {
            return;
        }
        this.refreshToolbar();
        this.refreshIdentity(this.current());
        this.refreshInfo();
    }

    private void refreshLayers() {
        this.identitiesFileNotFoundLayer.visible(this.team == null);
        this.teamEditorLayer.visible(this.team != null);
    }

    private void refreshToolbar() {
        this.previous.readonly(!this.canPrevious());
        this.next.readonly(!this.canNext());
    }

    private void refreshIdentity(Team.Identity identity) {
        this.identityViewer.identity(identity, this.team.grammar().getAll());
        this.identityViewer.refresh();
    }

    private void refreshInfo() {
        String message = this.condition != null && !this.condition.isEmpty() ? "%s " + this.translate("for") + " %s" : "%s";
        this.info.value(String.format(this.translate(message), this.identitiesCountMessage(this.identities.size()), this.condition));
    }

    private Team.Identity current() {
        return this.identities.size() > 0 ? this.identities.get(this.current) : null;
    }

    private void previous() {
        --this.current;
        if (this.current < 0) {
            this.current = 0;
        }
        this.refresh();
    }

    private boolean canPrevious() {
        return this.identities.size() > 0 && this.current > 0;
    }

    private void next() {
        ++this.current;
        if (this.current >= this.identities.size()) {
            this.current = this.identities.size() - 1;
        }
        this.refresh();
    }

    private boolean canNext() {
        return this.identities.size() > 0 && this.current < this.identities.size() - 1;
    }

    private void filter() {
        this.filter(this.condition);
        this.refresh();
    }

    public String identitiesCountMessage(int count) {
        if (count <= 0) {
            return this.translate("No identities");
        }
        if (count == 1) {
            return this.translate("1 identity");
        }
        return NumberFormat.getNumberInstance().format(count) + this.translate(" identities");
    }
}

