/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.DisplayHelper;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractPropertyViewer;

public class PropertyViewer
extends AbstractPropertyViewer<Box> {
    private Property _property;
    private String _value;

    public PropertyViewer(Box box) {
        super(box);
    }

    public PropertyViewer property(Property property) {
        this._property = property;
        return this;
    }

    public PropertyViewer value(String value) {
        this._value = value;
        return this;
    }

    public void refresh() {
        super.refresh();
        this.property.value(this._property.label());
        this.refreshStringValue();
        this.refreshImageValue();
    }

    private void refreshStringValue() {
        this.stringType.visible(this._property.type() == Property.Type.string);
        this.stringValue.value(this.isValid(this._value) ? this._value : "-");
    }

    private void refreshImageValue() {
        boolean isImage = this._property.type() == Property.Type.image;
        this.imageType.visible(isImage);
        if (!isImage) {
            return;
        }
        this.refreshImage(this._value);
    }

    private void refreshImage(String value) {
        if (!this.isValid(value)) {
            return;
        }
        this.imageValue.value(DisplayHelper.toUrl(this._property, value, this.username()));
    }

    private boolean isValid(String value) {
        return value != null && !value.isEmpty();
    }
}

