/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.alexandria.zif.grammar.PropertyChecker;
import io.intino.amidas.identityeditor.box.ui.displays.DisplayHelper;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractPropertyEditor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class PropertyEditor
extends AbstractPropertyEditor<Box> {
    private Property _property;
    private String _value;
    private Consumer<String> changeListener;

    public PropertyEditor(Box box) {
        super(box);
    }

    public PropertyEditor property(Property property) {
        this._property = property;
        return this;
    }

    public PropertyEditor value(String value) {
        this._value = value;
        return this;
    }

    public void onChange(Consumer<String> listener) {
        this.changeListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.initStringValue();
        this.initImageValue();
    }

    public void refresh() {
        super.refresh();
        this.property.value(this._property.label());
        this.refreshStringValue();
        this.refreshImageValue();
    }

    private void initStringValue() {
        this.stringValue.onChange(e -> {
            if (!this.check((String)e.value(), (v, error) -> {
                this.stringInvalidBlock.visible(true);
                this.stringInvalidValue.value((String)error);
            })) {
                return;
            }
            this.stringInvalidBlock.visible(false);
            this.changeListener.accept((String)e.value());
        });
    }

    private void initImageValue() {
        this.imageValue.onChange(e -> {
            String value = DisplayHelper.toString((Resource)e.value());
            if (!this.check(value, (v, error) -> {
                this.refreshImage((String)v);
                this.notifyUser((String)error, UserMessage.Type.Error);
            })) {
                return;
            }
            this.refreshImage(value);
            this.changeListener.accept(value);
        });
    }

    private void refreshStringValue() {
        this.stringType.visible(this._property.type() == Property.Type.string);
        this.stringValue.value(this._value);
        String grammar = this._property.grammar();
        this.stringGrammarBlock.visible(grammar != null && !grammar.isEmpty());
        this.stringGrammarLabel.value(this.translate(this._property.cardinality() == Property.Cardinality.multiple ? "options: " : "format: "));
        this.stringGrammar.value(grammar);
    }

    private void refreshImageValue() {
        boolean isImage = this._property.type() == Property.Type.image;
        this.imageType.visible(isImage);
        if (!isImage) {
            return;
        }
        this.refreshImage(this._value);
    }

    private void refreshImage(String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.imageValue.value(DisplayHelper.toUrl(this._property, value, this.username()));
    }

    private boolean check(String value, BiConsumer<String, String> updater) {
        String grammar = this._property.grammar();
        if (grammar == null || grammar.isEmpty() || value == null || value.isEmpty()) {
            return true;
        }
        String checkResult = new PropertyChecker(this._property).check(value);
        if (checkResult == null) {
            return true;
        }
        updater.accept(this._value, checkResult);
        return false;
    }
}

