/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractProfileEditor;
import io.intino.amidas.shared.Team;
import java.util.List;
import java.util.function.Consumer;

public class ProfileEditor
extends AbstractProfileEditor<Box> {
    private Team.Identity identity;
    private List<Property> properties;
    private Consumer<Team.Identity> identityModifiedListener;

    public ProfileEditor(Box box) {
        super(box);
    }

    public ProfileEditor identity(Team.Identity identity, List<Property> properties) {
        this.identity = identity;
        this.properties = properties;
        return this;
    }

    public ProfileEditor onModifyIdentity(Consumer<Team.Identity> listener) {
        this.identityModifiedListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initDialog();
    }

    private void initDialog() {
        this.openEditIdentity.onOpen(e -> {
            this.identityDialogBox.main.dialog.properties(this.properties);
            this.identityDialogBox.main.dialog.identity(this.identity);
            this.identityDialogBox.main.dialog.refresh();
        });
        this.cancel.onExecute(e -> this.identityDialogBox.close());
        this.accept.onExecute(e -> this.saveProfile());
    }

    private void saveProfile() {
        this.identityDialogBox.close();
        this.notifyUser(this.translate("Profile saved"), UserMessage.Type.Success);
        this.notifySave(this.identityDialogBox.main.dialog.identity());
        this.refreshIdentity();
    }

    private void notifySave(Team.Identity identity) {
        if (this.identityModifiedListener != null) {
            this.identityModifiedListener.accept(identity);
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshLayers();
        if (this.identity == null) {
            return;
        }
        this.refreshIdentity();
    }

    private void refreshLayers() {
        this.profileNotFoundLayer.visible(this.identity == null);
        this.profileEditorLayer.visible(this.identity != null);
    }

    private void refreshIdentity() {
        this.identityViewer.identity(this.identity, this.properties);
        this.identityViewer.refresh();
    }
}

