/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractIdentityViewer;
import io.intino.amidas.identityeditor.box.ui.displays.templates.PropertyViewer;
import io.intino.amidas.shared.Team;
import java.util.List;
import java.util.stream.Collectors;

public class IdentityViewer
extends AbstractIdentityViewer<Box> {
    private Team.Identity identity;
    private List<Property> _properties;

    public IdentityViewer(Box box) {
        super(box);
    }

    public IdentityViewer identity(Team.Identity identity, List<Property> properties) {
        this.identity = identity;
        this._properties = properties;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.featuresTitle.value(this.translate("Features"));
        this.credentialsTitle.value(this.translate("Credentials"));
        this.rolesTitle.value(this.translate("Roles"));
    }

    public void refresh() {
        super.refresh();
        this.showLoading();
        this.emptyLayer.emptyText.value(this.translate("No identities found"));
        this.refreshIdentity();
        this.hideLoading();
    }

    private void refreshIdentity() {
        if (this.identity == null) {
            return;
        }
        this.refreshFeatures();
        this.refreshCredentials();
        this.refreshRoles();
    }

    private void showLoading() {
        this.loadingLayer.visible(true);
        this.emptyLayer.visible(false);
        this.mainLayer.visible(false);
    }

    private void hideLoading() {
        this.loadingLayer.visible(false);
        this.emptyLayer.visible(this.identity == null);
        this.mainLayer.visible(this.identity != null);
    }

    private void refreshFeatures() {
        this.featuresPanel.featuresStamp.clear();
        this._properties.stream().filter(Property::isIdentifier).map(this::definitionOf).collect(Collectors.toList()).forEach(f -> this.fill((Team.Definition)f, (PropertyViewer)this.featuresPanel.featuresStamp.add()));
        this._properties.stream().filter(Property::isFeature).map(this::definitionOf).collect(Collectors.toList()).forEach(f -> this.fill((Team.Definition)f, (PropertyViewer)this.featuresPanel.featuresStamp.add()));
    }

    private void refreshCredentials() {
        this.credentialsPanel.visible(this._properties.stream().anyMatch(Property::isCredential));
        this.credentialsPanel.credentialsStamp.clear();
        this._properties.stream().filter(Property::isCredential).map(this::definitionOf).collect(Collectors.toList()).forEach(f -> this.fill((Team.Definition)f, (PropertyViewer)this.credentialsPanel.credentialsStamp.add()));
    }

    private void refreshRoles() {
        this.rolesPanel.visible(this._properties.stream().anyMatch(Property::isRole));
        this.rolesPanel.rolesStamp.clear();
        this._properties.stream().filter(Property::isRole).map(this::definitionOf).collect(Collectors.toList()).forEach(f -> this.fill((Team.Definition)f, (PropertyViewer)this.rolesPanel.rolesStamp.add()));
    }

    private void fill(Team.Definition definition, PropertyViewer viewer) {
        viewer.property(this.propertyOf(definition.property()));
        viewer.value(definition.value());
        viewer.refresh();
    }

    private Team.Definition definitionOf(final Property property) {
        return new Team.Definition(){

            public String property() {
                return property.name();
            }

            public String value() {
                Team.Statement statement = IdentityViewer.this.identity.get(property.name());
                return statement != null ? statement.value() : "";
            }
        };
    }

    private Property propertyOf(String name) {
        return this._properties.stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
    }
}

