/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractIdentityEditor;
import io.intino.amidas.identityeditor.box.ui.displays.templates.PropertyEditor;
import io.intino.amidas.shared.Team;
import java.util.List;

public class IdentityEditor
extends AbstractIdentityEditor<Box> {
    private Team.Identity identity;
    private List<Property> properties;

    public IdentityEditor(Box box) {
        super(box);
    }

    public IdentityEditor identity(Team.Identity identity) {
        this.identity = identity;
        return this;
    }

    public IdentityEditor properties(List<Property> properties) {
        this.properties = properties;
        return this;
    }

    public void refresh() {
        super.refresh();
        this.showLoading();
        this.refreshIdentity();
        this.hideLoading();
    }

    private void showLoading() {
        this.loadingLayer.visible(true);
        this.mainLayer.visible(false);
    }

    private void hideLoading() {
        this.loadingLayer.visible(false);
        this.mainLayer.visible(this.identity != null);
    }

    private void refreshIdentity() {
        this.propertiesStamp.clear();
        this.properties.forEach(p -> this.fill(this.definitionOf(p.name()), (PropertyEditor)this.propertiesStamp.add()));
    }

    private void fill(Team.Definition definition, PropertyEditor editor) {
        editor.property(this.propertyOf(definition.property()));
        editor.value(definition.value());
        editor.onChange(value -> this.appendDefinition(definition, (String)value));
        editor.refresh();
    }

    private Team.Definition definitionOf(String property) {
        Team.Statement statement = this.identity.get(property);
        String value = statement != null ? statement.value() : "";
        return this.definitionOf(property, value);
    }

    private Team.Definition definitionOf(final String property, final String value) {
        return new Team.Definition(){

            public String property() {
                return property;
            }

            public String value() {
                return value;
            }
        };
    }

    private void appendDefinition(Team.Definition definition, String value) {
        this.identity.append(this.definitionOf(definition.property(), value));
    }

    private Property propertyOf(String name) {
        return this.properties.stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
    }
}

