/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.logger.Logger;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.ui.displays.notifiers.ErrorTemplateNotifier;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractErrorTemplate;
import java.io.File;
import java.net.MalformedURLException;

public class ErrorTemplate
extends AbstractErrorTemplate<IdentityEditorBox> {
    public ErrorTemplate(IdentityEditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.logoutButton.onExecute(e -> {
            this.session().logout();
            ((ErrorTemplateNotifier)this.notifier).redirect(this.session().browser().homeUrl());
        });
        this.accessMessage.value(this.translate("You don't have access permissions"));
        this.initLogo();
        this.initBackground();
    }

    private void initLogo() {
        try {
            File file = new File(((IdentityEditorBox)this.box()).configuration().logo());
            if (!file.exists()) {
                return;
            }
            this.logo.value(file.toPath().toUri().toURL());
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
        }
    }

    private void initBackground() {
        try {
            File file = new File(((IdentityEditorBox)this.box()).configuration().background());
            if (!file.exists()) {
                return;
            }
            this.background.value(file.toPath().toUri().toURL());
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
        }
    }
}

