/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui.displays;

import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRouteDispatcher
implements DisplayRouteDispatcher {
    private static Map<String, String> patterns = new HashMap<String, String>();

    public AbstractRouteDispatcher() {
        this.registerPatterns();
    }

    public void dispatch(Soul soul, String address) {
        address = address.replaceFirst(soul.session().browser().basePath(), "");
        List<String> params = this.paramsOf(address);
        if (address.length() <= 1) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("home"))) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("team"))) {
            this.dispatchTeam(soul);
            return;
        }
        if (address.length() <= 1) {
            this.dispatchProfile(soul);
            return;
        }
        if (address.matches(patterns.get("profile"))) {
            this.dispatchProfile(soul);
            return;
        }
        if (address.length() <= 1) {
            this.dispatchError(soul);
            return;
        }
        if (address.matches(patterns.get("error"))) {
            this.dispatchError(soul);
            return;
        }
    }

    public abstract void dispatchHome(Soul var1);

    public abstract void dispatchTeam(Soul var1);

    public abstract void dispatchProfile(Soul var1);

    public abstract void dispatchError(Soul var1);

    private void registerPatterns() {
        if (patterns.size() > 0) {
            return;
        }
        patterns.put("home", "");
        patterns.put("team", "\\/team");
        patterns.put("profile", "\\/profile");
        patterns.put("error", "\\/error");
    }

    private String patternOf(String address) {
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("team"))) {
            return patterns.get("team");
        }
        if (address.matches(patterns.get("profile"))) {
            return patterns.get("profile");
        }
        if (address.matches(patterns.get("profile"))) {
            return patterns.get("profile");
        }
        if (address.matches(patterns.get("error"))) {
            return patterns.get("error");
        }
        if (address.matches(patterns.get("error"))) {
            return patterns.get("error");
        }
        return null;
    }

    private List<String> paramsOf(String address) {
        return this.paramsOf(address, this.patternOf(address));
    }

    private List<String> paramsOf(String address, String pattern) {
        if (pattern == null) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(address);
        if (!m.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i));
        }
        return result;
    }
}

