/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.ui;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.push.User;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.shared.Team;
import java.time.Instant;
import java.util.List;

public class TeamHelper {
    public static boolean isIdentityManager(IdentityEditorBox box, User user) {
        if (box.team() == null) {
            return true;
        }
        if (user == null) {
            return true;
        }
        String role = box.configuration().identitiesManagerRole();
        List result = box.team().search("role/" + role, "");
        return result.stream().filter(i -> TeamHelper.isIdentityOfUserLogged(i, user)).anyMatch(i -> TeamHelper.isIdentityRoleEnabled(i, role));
    }

    private static boolean isIdentityOfUserLogged(Team.Identity identity, User user) {
        try {
            if (user == null) {
                return false;
            }
            String username = user.username();
            return identity.ids().stream().anyMatch(id -> id.value().equals(username));
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            return false;
        }
    }

    private static boolean isIdentityRoleEnabled(Team.Identity identity, String role) {
        Team.Role identityRole = identity.getRole(role);
        if (identityRole == null) {
            return false;
        }
        return identityRole.isEnabled(Instant.now());
    }
}

