/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.commands.identity;

import io.intino.alexandria.Base64;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.datahub.events.Identities;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.Command;
import io.intino.amidas.shared.Team;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class SaveIdentityCommand
extends Command<Team.Identity> {
    public Team.Identity identity;

    public SaveIdentityCommand(IdentityEditorBox box) {
        super(box);
    }

    @Override
    public Team.Identity execute() {
        Identities identities = this.buildSchema();
        if (identities == null) {
            Logger.error((String)"SaveIdentityCommand: Could not create schema");
        }
        this.feed(identities);
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Identities buildSchema() {
        Path temporalFile = null;
        try {
            temporalFile = Files.createTempFile(this.identifiesFilename() + "_", ".zif", new FileAttribute[0]);
            Path path = new File(this.box.configuration().identitiesFile()).toPath();
            Files.copy(path, temporalFile, StandardCopyOption.REPLACE_EXISTING);
            Team team = new Team(temporalFile.toFile());
            team.build(this.identity).save();
            Identities identities = this.setup(new Identities()).zif(Base64.encode((byte[])Files.readAllBytes(temporalFile)));
            return identities;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            Identities identities = null;
            return identities;
        }
        finally {
            if (temporalFile != null) {
                temporalFile.toFile().delete();
            }
        }
    }

    private String identifiesFilename() {
        File current = new File(this.box.configuration().identitiesFile());
        return current.getName().substring(0, current.getName().lastIndexOf("."));
    }
}

