/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.identityeditor.box.commands;

import io.intino.alexandria.logger.Logger;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.Command;
import java.io.IOException;
import java.net.URL;
import java.time.Clock;
import java.time.Instant;
import java.util.Base64;
import org.apache.commons.io.IOUtils;

public class Commands {
    protected final IdentityEditorBox box;

    public Commands(IdentityEditorBox box) {
        this.box = box;
    }

    protected <C extends Command> C setup(C command, String author) {
        command.author = author;
        command.ts = Instant.now(Clock.systemUTC());
        return command;
    }

    protected String toBase64(URL documento) {
        try {
            if (documento == null) {
                return "";
            }
            byte[] bytes = IOUtils.toByteArray((URL)documento);
            return new String(Base64.getEncoder().encode(bytes));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

