import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractTeamEditor from "../../../gen/displays/templates/AbstractTeamEditor";
import TeamEditorNotifier from "../../../gen/displays/notifiers/TeamEditorNotifier";
import TeamEditorRequester from "../../../gen/displays/requesters/TeamEditorRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TeamEditor extends AbstractTeamEditor {

	constructor(props) {
		super(props);
		this.notifier = new TeamEditorNotifier(this);
		this.requester = new TeamEditorRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TeamEditor));
DisplayFactory.register("TeamEditor", withStyles(styles, { withTheme: true })(withSnackbar(TeamEditor)));