import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractIdentityDialog from "../../../gen/displays/templates/AbstractIdentityDialog";
import IdentityDialogNotifier from "../../../gen/displays/notifiers/IdentityDialogNotifier";
import IdentityDialogRequester from "../../../gen/displays/requesters/IdentityDialogRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class IdentityDialog extends AbstractIdentityDialog {

	constructor(props) {
		super(props);
		this.notifier = new IdentityDialogNotifier(this);
		this.requester = new IdentityDialogRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(IdentityDialog));
DisplayFactory.register("IdentityDialog", withStyles(styles, { withTheme: true })(withSnackbar(IdentityDialog)));