package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.identityeditor.box.*;

import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractErrorTemplate;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ErrorTemplate extends AbstractErrorTemplate<IdentityEditorBox> {

    public ErrorTemplate(IdentityEditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        logoutButton.onExecute(e -> {
            session().logout();
            notifier.redirect(session().browser().homeUrl());
        });
        accessMessage.value(translate("You don't have access permissions"));
        initLogo();
        initBackground();
    }

    private void initLogo() {
        try {
            File file = new File(box().configuration().logo());
            if (!file.exists()) return;
            logo.value(file.toPath().toUri().toURL());
        } catch (MalformedURLException e) {
            Logger.error(e);
        }
    }

    private void initBackground() {
        try {
            File file = new File(box().configuration().background());
            if (!file.exists()) return;
            background.value(file.toPath().toUri().toURL());
        } catch (MalformedURLException e) {
            Logger.error(e);
        }
    }

}