package io.intino.amidas.identityeditor.box.subscribers;

import io.intino.alexandria.ui.Soul;
import io.intino.amidas.identityeditor.box.ContextManager;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.ui.displays.templates.ProfileTemplate;
import io.intino.amidas.identityeditor.box.ui.displays.templates.TeamTemplate;

public class IdentitiesSubscriber implements java.util.function.Consumer<io.intino.amidas.datahub.events.Identities> {
	private IdentityEditorBox box;

	public IdentitiesSubscriber(IdentityEditorBox box) {
		this.box = box;
	}

	public void accept(io.intino.amidas.datahub.events.Identities event) {
		box.mounterFactory().handle(event);
		ContextManager.souls().forEach(this::notifyTeam);
		ContextManager.clear();
	}

	private void notifyTeam(Soul soul) {
		TeamTemplate display = soul.display(TeamTemplate.class);
		if (display == null) return;
		display.reloadTeam();
	}
}