package io.intino.amidas.identityeditor.box.commands;

import io.intino.alexandria.event.Event;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;

import java.time.Clock;
import java.time.Instant;

public abstract class Command<T> {
	public final IdentityEditorBox box;
	public String author;
	public Instant ts;

	public Command(IdentityEditorBox box) {
		this.box = box;
	}

	public abstract T execute();

	protected <E extends Event> void feed(E evento) {
		feed(evento, "comercial.cuentamaestra");
	}

	protected <E extends Event> void feedFacturacion(E evento) {
		feed(evento, "facturacion");
	}

	protected <E extends Event> void feed(E evento, String context) {
		if (box.terminal() == null) return;
		box.terminal().publish(evento, context);
	}

	protected <E extends Event> E setup(E result) {
		result.ss("Interfaz de usuario . " + author);
		result.ts(ts());
		return result;
	}

	protected static Instant ts() {
		return Instant.now(Clock.systemUTC());
	}

}