import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import DisplaysHeader from "identity-editor-elements/src/displays/templates/Header";
import DisplaysProfileEditor from "identity-editor-elements/src/displays/templates/ProfileEditor";
import DisplaysFooter from "identity-editor-elements/src/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractProfileTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1515148925" layout="vertical" width="100.0%" height="100.0%">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_253815370" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1153102793">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_953481250" layout="vertical flexible">
						<DisplaysProfileEditor context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1936588526">
						</DisplaysProfileEditor>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1076257238" layout="vertical">
						<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_971922758">
						</DisplaysFooter>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}