import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysPropertyViewer from "identity-editor-elements/src/displays/templates/PropertyViewer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractIdentityViewer extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_755652684" format="bordered airTop" visible={false} layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1732484785" format="h5" mode="normal">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1199389989" visible={false} layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_128396962" mode="Rise">
					</UiSpinner>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032" format="airTop" visible={false} layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1348836048" format="whiteBackground air airRight" layout="vertical flexible" width="calc(33% - 20px)" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1881263948" format="h5 airBottom" mode="normal" value="Features">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1880649911" multiple={{instances:"featuresStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1794867617" format="whiteBackground air airRight" visible={false} layout="vertical flexible" width="calc(33% - 20px)" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1007281508" format="h5 airBottom" mode="normal" value="Credentials">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1007895545" multiple={{instances:"credentialsStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1036662658" format="whiteBackground air" visible={false} layout="vertical flexible" width="calc(33% - 20px)" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1687272452" format="h5 airBottom" mode="normal" value="Roles">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1687886489" multiple={{instances:"rolesStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}