import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import DisplaysIdentityViewer from "identity-editor-elements/gen/displays/templates/IdentityViewer";
import DisplaysIdentityDialog from "identity-editor-elements/gen/displays/templates/IdentityDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TeamEditorNotifier from "identity-editor-elements/gen/displays/notifiers/TeamEditorNotifier";
import TeamEditorRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TeamEditor extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TeamEditorNotifier(this);
		this.requester = new TeamEditorRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="air" layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_142276588" visible={false} layout="vertical flexible centercenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_142276588.a787432464" format="h5" mode="normal" value="Identities file not found. Check your configuration.">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009" visible={false} layout="vertical flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165" format="relative" layout="horizontal">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a1808003305" title="Previous identity" target="self" mode="MaterialIconButton" icon="NavigateBefore" size="Small" format="airRight">
						</UiAction>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a356551141" title="Next identity" target="self" mode="MaterialIconButton" icon="NavigateNext" size="Small" format="airRight">
						</UiAction>
						<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a1676165539" title="Add identity" target="self" mode="MaterialIconButton" icon="Add" size="Small" format="airRight" visible={false}>
						</UiOpenDialog>
						<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a_1417471932" title="Edit identity" target="self" mode="MaterialIconButton" icon="Create" size="Small" format="airRight">
						</UiOpenDialog>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a_1937159268" format="relative" layout="horizontal start" width="450px" height="-1px">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a_1937159268.a_1822012821" mode="normal" placeholder="Search identity...">
							</UiTextEditable>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a_1937159268.a_574251471" format="searchInfo" mode="normal">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a96384316" layout="horizontal start">
							<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a854129165.a96384316.a734529907" title="Download identities" target="self" mode="MaterialIconButton" icon="CloudDownload" size="Small" format="airLeft">
							</UiDownload>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a552223771" layout="vertical flexible">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a552223771.a2136354559" layout="vertical flexible centercenter">
							<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a552223771.a2136354559.a_158744470" mode="Rise">
							</UiSpinner>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a552223771.a2089363177" visible={false} layout="vertical flexible" width="100.0%" height="100.0%">
							<DisplaysIdentityViewer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a552223771.a2089363177.a216137862">
							</DisplaysIdentityViewer>
						</UiBlock>
					</UiBlock>
					<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751" title="Edit identity" width="60.0%" height="80.0%">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751.a36582561" format="autoOverflow minWidth" layout="vertical flexible" width="100.0%" height="calc(100% - 45px)">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751.a36582561.a_1507221941" format="doubleAirLeft doubleAirRight" layout="vertical">
								<DisplaysIdentityDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751.a36582561.a_1507221941.a_2073378372">
								</DisplaysIdentityDialog>
							</UiBlock>
						</UiBlock>
						<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751.a1942443261">
						</UiDivider>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751.a_2044315256" layout="horizontal endjustified">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751.a_2044315256.a_403254779" title="Cancel" target="self" mode="Button" size="Medium" format="airRight">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a873933009.a441329751.a_2044315256.a_458991469" title="Accept" target="self" mode="Button" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
					</UiDialog>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TeamEditor));
DisplayFactory.register("TeamEditor", withStyles(styles, { withTheme: true })(withSnackbar(TeamEditor)));