import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import PropertyViewerNotifier from "identity-editor-elements/gen/displays/notifiers/PropertyViewerNotifier";
import PropertyViewerRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PropertyViewer extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new PropertyViewerNotifier(this);
		this.requester = new PropertyViewerRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="airBottom propertyViewerStyle" layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1495460750" format="description" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1971680868" visible={false} layout="vertical flexible">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1971680868.a1720844933" format="propertyValue" mode="normal">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1040895844" format="propertyImageView" visible={false} layout="vertical flexible" width="150px" height="200px">
					<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1040895844.a_863665063" format="propertyImageTypeSize propertyValue">
					</UiImage>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(PropertyViewer));
DisplayFactory.register("PropertyViewer", withStyles(styles, { withTheme: true })(withSnackbar(PropertyViewer)));