import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiImageEditable from "alexandria-ui-elements/src/displays/components/ImageEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import PropertyEditorNotifier from "identity-editor-elements/gen/displays/notifiers/PropertyEditorNotifier";
import PropertyEditorRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PropertyEditor extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new PropertyEditorNotifier(this);
		this.requester = new PropertyEditorRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="airBottom" layout="horizontal center" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_77738808" layout="vertical" width="40.0%" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_77738808.a_1145724228" format="description" mode="normal">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_984158167" visible={false} layout="vertical flexible">
					<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_984158167.a_37094198" format="propertyValue" mode="normal">
					</UiTextEditable>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_984158167.a_1659966547" visible={false} layout="horizontal">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_984158167.a_1659966547.a_1054780400" format="description middleAirRight" mode="normal" value="options: ">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_984158167.a_1659966547.a_1209277116" format="description" mode="normal">
						</UiText>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_984158167.a_1759685795" visible={false} layout="horizontal">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_984158167.a_1759685795.a_1754109811" format="middleAirRight propertyError" mode="normal" value="Value is not valid">
						</UiText>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249227831" visible={false} layout="vertical flexible">
					<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249227831.a_141472802" format="propertyImageTypeSize propertyValue">
					</UiImageEditable>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(PropertyEditor));
DisplayFactory.register("PropertyEditor", withStyles(styles, { withTheme: true })(withSnackbar(PropertyEditor)));