import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import DisplaysIdentityViewer from "identity-editor-elements/gen/displays/templates/IdentityViewer";
import DisplaysIdentityDialog from "identity-editor-elements/gen/displays/templates/IdentityDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ProfileEditorNotifier from "identity-editor-elements/gen/displays/notifiers/ProfileEditorNotifier";
import ProfileEditorRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ProfileEditor extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ProfileEditorNotifier(this);
		this.requester = new ProfileEditorRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="air" layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1479262271" visible={false} layout="vertical flexible centercenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1479262271.a1044219100" format="h5" mode="normal" value="Profile not found. Contact with administrator.">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267" visible={false} layout="vertical flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530" format="center" layout="vertical" width="70.0%" height="100.0%">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a1105692677" layout="horizontal">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a1105692677.a2133014860" title="Edit identity" target="self" mode="MaterialIconButton" icon="Create" size="Small" format="airRight">
							</UiOpenDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a_1618437492" layout="vertical flexible">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a_1618437492.a_815034237" layout="vertical flexible" width="100.0%" height="100.0%">
								<DisplaysIdentityViewer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a_1618437492.a_815034237.a2126275327">
								</DisplaysIdentityViewer>
							</UiBlock>
						</UiBlock>
						<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a936222799" title="Edit profile">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a936222799.a871561129" format="minWidth" layout="vertical flexible" width="550px" height="-1px">
								<DisplaysIdentityDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a936222799.a871561129.a_3554658">
								</DisplaysIdentityDialog>
							</UiBlock>
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a936222799.a_752248223">
							</UiDivider>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a936222799.a_562408116" layout="horizontal endjustified">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a936222799.a_562408116.a_276732051" title="Cancel" target="self" mode="Button" size="Medium" format="airRight">
								</UiAction>
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1694675267.a_1698095530.a936222799.a_562408116.a_332468741" title="Accept" target="self" mode="Button" size="Medium" highlighted="Fill">
								</UiAction>
							</UiBlock>
						</UiDialog>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ProfileEditor));
DisplayFactory.register("ProfileEditor", withStyles(styles, { withTheme: true })(withSnackbar(ProfileEditor)));