import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysPropertyViewer from "identity-editor-elements/gen/displays/templates/PropertyViewer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import IdentityViewerNotifier from "identity-editor-elements/gen/displays/notifiers/IdentityViewerNotifier";
import IdentityViewerRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class IdentityViewer extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new IdentityViewerNotifier(this);
		this.requester = new IdentityViewerRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_755652684" format="airTop bordered" visible={false} layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_755652684.a_1732484785" format="h5" mode="normal">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1199389989" visible={false} layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1199389989.a_196349312" mode="Rise">
					</UiSpinner>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032" format="airTop" visible={false} layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1348836048" format="air airRight whiteBackground" layout="vertical flexible" width="calc(33% - 20px)" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1348836048.a1881263948" format="airBottom h5" mode="normal" value="Features">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1348836048.a1880649911" multiple={{instances:"featuresStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1794867617" format="air airRight whiteBackground" visible={false} layout="vertical flexible" width="calc(33% - 20px)" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1794867617.a_1007281508" format="airBottom h5" mode="normal" value="Credentials">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1794867617.a_1007895545" multiple={{instances:"credentialsStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1036662658" format="air whiteBackground" visible={false} layout="vertical flexible" width="calc(33% - 20px)" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1036662658.a_1687272452" format="airBottom h5" mode="normal" value="Roles">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_258747032.a_1036662658.a_1687886489" multiple={{instances:"rolesStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(IdentityViewer));
DisplayFactory.register("IdentityViewer", withStyles(styles, { withTheme: true })(withSnackbar(IdentityViewer)));