import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ErrorTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ErrorTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ErrorTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ErrorTemplateNotifier(this);
		this.requester = new ErrorTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1515050422" format="backgroundLogin">
				</UiImage>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802" format="grey" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717" format="visible" layout="vertical" width="400px" height="200px" paper>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717.a_1472783281" format="relative" layout="vertical flexible centerjustified" width="100.0%" height="100.0%" spacing="16">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717.a_1472783281.a1467446060" layout="vertical centercenter">
								<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717.a_1472783281.a1467446060.a_319732219">
								</UiImage>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717.a_1472783281.a1467446060.a1395592937" format="airTop h4" mode="normal">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717.a1877255846" layout="vertical">
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717.a1877255846.a357885206">
							</UiDivider>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124762802.a1030768717.a1877255846.a888398591" title="Logout" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ErrorTemplate));
DisplayFactory.register("ErrorTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ErrorTemplate)));