import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import DisplaysHeader from "identity-editor-elements/gen/displays/templates/Header";
import DisplaysTeamEditor from "identity-editor-elements/gen/displays/templates/TeamEditor";
import DisplaysFooter from "identity-editor-elements/gen/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TeamTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TeamTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TeamTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TeamTemplateNotifier(this);
		this.requester = new TeamTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851" layout="vertical" width="100.0%" height="100.0%">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a_2111889396" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a_2111889396.a686500363">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a1393029709" layout="vertical flexible centercenter">
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a1393029709.a1015669025" mode="Rise">
						</UiSpinner>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a_1758372809" visible={false} layout="vertical flexible">
						<DisplaysTeamEditor context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a_1758372809.a_866047055">
						</DisplaysTeamEditor>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a_624986471" layout="vertical">
						<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1953097851.a_624986471.a899780323">
						</DisplaysFooter>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TeamTemplate));
DisplayFactory.register("TeamTemplate", withStyles(styles, { withTheme: true })(withSnackbar(TeamTemplate)));