import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import DisplaysHeader from "identity-editor-elements/gen/displays/templates/Header";
import DisplaysProfileEditor from "identity-editor-elements/gen/displays/templates/ProfileEditor";
import DisplaysFooter from "identity-editor-elements/gen/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ProfileTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ProfileTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ProfileTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ProfileTemplateNotifier(this);
		this.requester = new ProfileTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_644788788" layout="vertical" width="100.0%" height="100.0%">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_644788788.a_392986674" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_644788788.a_392986674.a_1862090103">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_644788788.a204947878" layout="vertical flexible">
						<DisplaysProfileEditor context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_644788788.a204947878.a437035046">
						</DisplaysProfileEditor>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_644788788.a_386161450" layout="vertical">
						<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_644788788.a_386161450.a1751477671">
						</DisplaysFooter>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ProfileTemplate));
DisplayFactory.register("ProfileTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ProfileTemplate)));