import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysPropertyEditor from "identity-editor-elements/gen/displays/templates/PropertyEditor";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import IdentityEditorNotifier from "identity-editor-elements/gen/displays/notifiers/IdentityEditorNotifier";
import IdentityEditorRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class IdentityEditor extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new IdentityEditorNotifier(this);
		this.requester = new IdentityEditorRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_388539990" visible={false} layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_388539990.a5697438" mode="Rise">
					</UiSpinner>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1031376643" format="airTop" visible={false} layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1031376643.a1451957497" layout="vertical flexible">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1031376643.a1451957497.a_1802399059" multiple={{instances:"propertiesStamp",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(IdentityEditor));
DisplayFactory.register("IdentityEditor", withStyles(styles, { withTheme: true })(withSnackbar(IdentityEditor)));