import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysIdentityEditor from "identity-editor-elements/gen/displays/templates/IdentityEditor";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import IdentityDialogNotifier from "identity-editor-elements/gen/displays/notifiers/IdentityDialogNotifier";
import IdentityDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class IdentityDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new IdentityDialogNotifier(this);
		this.requester = new IdentityDialogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" style={{...this.props.style,...display}}>
				<DisplaysIdentityEditor context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1293402501">
				</DisplaysIdentityEditor>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(IdentityDialog));
DisplayFactory.register("IdentityDialog", withStyles(styles, { withTheme: true })(withSnackbar(IdentityDialog)));