import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiUser from "alexandria-ui-elements/src/displays/components/User";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HeaderNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HeaderRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Header extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HeaderNotifier(this);
		this.requester = new HeaderRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal center" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a102854121" layout="horizontal center flexible" spacing="8">
					<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a102854121.a_1403727509" width="200px" height="50px">
					</UiImage>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a102854121.a433976371" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a102854121.a433976371.a1008904155" format="h2" mode="normal" value="Identities">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a102854121.a433976371.a_107859019" format="grey h5" visible={false} mode="normal" value="slogan">
						</UiText>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a713663053" format="h6 secondary" layout="horizontal center endjustified" spacing="16">
					<UiUser context={this._context.bind(this)} owner={this._owner.bind(this)} id="a713663053.a_618897707" color="grey" mode="PhotoWithFullname">
					</UiUser>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Header));
DisplayFactory.register("Header", withStyles(styles, { withTheme: true })(withSnackbar(Header)));