import AlexandriaUiI18n from "alexandria-ui-elements/gen/I18n";

const I18n = (function () {
    var cache = {};

	var translators = {
		"mx" : {
			"Previous identity" : "Identidad anterior",
			"Next identity" : "Identidad siguiente",
			"Add identity" : "Añadir identidad",
			"Remove identity" : "Borrar identidad",
			"Edit identity" : "Editar identidad",
			"Search identity..." : "Buscar identidad...",
			"No identities found" : "No se han encontrado identidades",
			"Are you sure you want to remove identity?" : "¿Está seguro que desea borrar la identidad?",
			"Features" : "Características",
			"Credentials" : "Credenciales",
			"Roles" : "Roles",
			"No identities" : "No hay identidades",
			"1 identity" : "1 identidad",
			" identities" : " identidades",
			"for" : "para",
			"Cancel" : "Cancelar",
			"OK" : "Aceptar",
			"Accept" : "Aceptar",
			"Identity saved" : "Se ha guardado la identidad correctamente",
			"Identities file not found. Check your configuration." : "No se ha encontrado el fichero de identidades. Por favor, compruebe su configuración.",
			"options: " : "opciones: ",
			"format: " : "formato: ",
			"Affirm" : "Afirmación",
			"You don't have access permissions" : "No tiene permisos para acceder",
			"Logout" : "Cerrar sesión",
			"Already in use" : "Ya está en uso"
		}
	};

    function merge(dictionary, lang) {
        if (dictionary == null) dictionary = {};
        addWords(dictionary, AlexandriaUiI18n.load(lang));
        return dictionary;
    };

    function addWords(dictionary, words) {
        if (words == null) return;
        for (var index in words) dictionary[index] = words[index];
        return dictionary;
    };

	var loader = {
		load: (lang) => {
            if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
            return cache[lang];
		}
	};

	return loader;
})();

export default I18n;