/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import io.intino.amidas.schemas.DecisionOption;
import io.intino.amidas.schemas.RequestPolicy;
import io.intino.amidas.schemas.RequestProperties;
import io.intino.konos.alexandria.exceptions.BadRequest;
import io.intino.konos.alexandria.exceptions.Conflict;
import io.intino.konos.alexandria.exceptions.NotFound;
import io.intino.konos.alexandria.exceptions.Unknown;
import io.intino.konos.alexandria.schema.Resource;
import io.intino.konos.restful.core.RestfulAccessor;
import io.intino.konos.restful.exceptions.RestfulFailure;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmidasTaskAccessor {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private URL url;
    private static Gson gsonReader = AmidasTaskAccessor.gsonReader();
    private static Gson gsonWriter = AmidasTaskAccessor.gsonWriter();
    private RestfulAccessor accessor = new RestfulAccessor();

    public AmidasTaskAccessor(URL url) {
        this.url = url;
    }

    public String putRequestForEdition(final String token, final RequestProperties properties, final RequestPolicy policy, final String editor, final String document, Resource preview) throws BadRequest, Conflict, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                    if (properties != null) {
                        this.put("properties", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)properties))));
                    }
                    if (policy != null) {
                        this.put("policy", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)policy))));
                    }
                    if (editor != null) {
                        this.put("editor", editor);
                    }
                    if (document != null) {
                        this.put("document", document);
                    }
                }
            };
            return String.valueOf(this.accessor.put(this.url, "/api/task/request/edition", (Map)parameters, Arrays.asList(preview)).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("409")) {
                throw new Conflict(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public String putRequestForDecision(final String token, final RequestProperties properties, final RequestPolicy policy, final List<DecisionOption> options, final String document, Resource preview) throws BadRequest, Conflict, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                    if (properties != null) {
                        this.put("properties", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)properties))));
                    }
                    if (policy != null) {
                        this.put("policy", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)policy))));
                    }
                    if (options != null) {
                        this.put("options", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)options))));
                    }
                    if (document != null) {
                        this.put("document", document);
                    }
                }
            };
            return String.valueOf(this.accessor.put(this.url, "/api/task/request/decision", (Map)parameters, Arrays.asList(preview)).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("409")) {
                throw new Conflict(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public String putRequestForDocumentSignature(final String token, final RequestProperties properties, final RequestPolicy policy, final String type, final String format, Resource signature, Resource document, Resource preview) throws BadRequest, Conflict, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                    if (properties != null) {
                        this.put("properties", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)properties))));
                    }
                    if (policy != null) {
                        this.put("policy", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)policy))));
                    }
                    if (type != null) {
                        this.put("type", type);
                    }
                    if (format != null) {
                        this.put("format", format);
                    }
                }
            };
            return String.valueOf(this.accessor.put(this.url, "/api/task/request/document/signature", (Map)parameters, Arrays.asList(signature, document, preview)).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("409")) {
                throw new Conflict(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public String putRequestForDocumentEdition(final String token, final RequestProperties properties, final RequestPolicy policy, Resource document, Resource preview, final String mode) throws BadRequest, Conflict, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                    if (properties != null) {
                        this.put("properties", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)properties))));
                    }
                    if (policy != null) {
                        this.put("policy", AmidasTaskAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)policy))));
                    }
                    if (mode != null) {
                        this.put("mode", mode);
                    }
                }
            };
            return String.valueOf(this.accessor.put(this.url, "/api/task/request/document/edition", (Map)parameters, Arrays.asList(document, preview)).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("409")) {
                throw new Conflict(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public Resource getTaskDocument(final String token, String task) throws BadRequest, NotFound, Conflict, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                }
            };
            return this.accessor.getResource(this.url, "/api/task/" + task + "/document", (Map)parameters);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("404")) {
                throw new NotFound(e.label());
            }
            if (e.code().equals("409")) {
                throw new Conflict(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public Boolean postTaskDocument(final String token, String task, Resource document, final Boolean completed) throws BadRequest, NotFound, Conflict, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                    if (completed != null) {
                        this.put("completed", String.valueOf(completed));
                    }
                }
            };
            return Boolean.valueOf(this.accessor.post(this.url, "/api/task/" + task + "/document", (Map)parameters, Arrays.asList(document)).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("404")) {
                throw new NotFound(e.label());
            }
            if (e.code().equals("409")) {
                throw new Conflict(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public Boolean postRejectTask(final String token, String task, String reason) throws NotFound, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                }
            };
            return Boolean.valueOf(this.accessor.post(this.url, "/api/task/" + task + "/reject", (Map)parameters).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("404")) {
                throw new NotFound(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public Boolean postCompleteTask(final String token, String task) throws BadRequest, NotFound, Conflict, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (token != null) {
                        this.put("token", token);
                    }
                }
            };
            return Boolean.valueOf(this.accessor.post(this.url, "/api/task/" + task + "/complete", (Map)parameters).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("404")) {
                throw new NotFound(e.label());
            }
            if (e.code().equals("409")) {
                throw new Conflict(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static Gson gsonReader() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (json, type1, jsonDeserializationContext) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (json, type1, jsonDeserializationContext) -> new Date(json.getAsJsonPrimitive().getAsLong())).create();
    }

    private static Gson gsonWriter() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (instant, type, context) -> new JsonPrimitive((Number)instant.toEpochMilli())).registerTypeAdapter(Date.class, (date, type, context) -> new JsonPrimitive((Number)date.getTime())).create();
    }
}

