package io.intino.amidas.schemas;

import io.intino.amidas.schemas.*;

public  class Task implements java.io.Serializable {

	private String name = "";
	private String label = "";
	private Boolean edited = true;
	private Boolean editionCompleted = true;
	private String preview = "";
	private String previewType = "";
	private String type = "";
	private Edition edition;
	private Decision decision;
	private DocumentSignature documentSignature;
	private DocumentEdition documentEdition;

	public String name() {
		return this.name;
	}

	public String label() {
		return this.label;
	}

	public Boolean edited() {
		return this.edited;
	}

	public Boolean editionCompleted() {
		return this.editionCompleted;
	}

	public String preview() {
		return this.preview;
	}

	public String previewType() {
		return this.previewType;
	}

	public String type() {
		return this.type;
	}

	public Edition edition() {
		return this.edition;
	}

	public Decision decision() {
		return this.decision;
	}

	public DocumentSignature documentSignature() {
		return this.documentSignature;
	}

	public DocumentEdition documentEdition() {
		return this.documentEdition;
	}

	public Task name(String name) {
		this.name = name;
		return this;
	}

	public Task label(String label) {
		this.label = label;
		return this;
	}

	public Task edited(Boolean edited) {
		this.edited = edited;
		return this;
	}

	public Task editionCompleted(Boolean editionCompleted) {
		this.editionCompleted = editionCompleted;
		return this;
	}

	public Task preview(String preview) {
		this.preview = preview;
		return this;
	}

	public Task previewType(String previewType) {
		this.previewType = previewType;
		return this;
	}

	public Task type(String type) {
		this.type = type;
		return this;
	}

	public Task edition(Edition edition) {
		this.edition = edition;
		return this;
	}

	public Task decision(Decision decision) {
		this.decision = decision;
		return this;
	}

	public Task documentSignature(DocumentSignature documentSignature) {
		this.documentSignature = documentSignature;
		return this;
	}

	public Task documentEdition(DocumentEdition documentEdition) {
		this.documentEdition = documentEdition;
		return this;
	}

	public static class Edition implements java.io.Serializable {

		private String editorPath = "";

		public String editorPath() {
			return this.editorPath;
		}

		public Edition editorPath(String editorPath) {
			this.editorPath = editorPath;
			return this;
		}

	}
	public static class Decision implements java.io.Serializable {

		private java.util.List<DecisionOption> decisionOptionList = new java.util.ArrayList<>();

		public java.util.List<DecisionOption> decisionOptionList() {
			return this.decisionOptionList;
		}

		public Decision decisionOptionList(java.util.List<DecisionOption> decisionOptionList) {
			this.decisionOptionList = decisionOptionList;
			return this;
		}

	}
	public static class DocumentSignature implements java.io.Serializable {

		private String document = "";
		private String signature = "";
		private String type = "";
		private String format = "";

		public String document() {
			return this.document;
		}

		public String signature() {
			return this.signature;
		}

		public String type() {
			return this.type;
		}

		public String format() {
			return this.format;
		}

		public DocumentSignature document(String document) {
			this.document = document;
			return this;
		}

		public DocumentSignature signature(String signature) {
			this.signature = signature;
			return this;
		}

		public DocumentSignature type(String type) {
			this.type = type;
			return this;
		}

		public DocumentSignature format(String format) {
			this.format = format;
			return this;
		}

	}
	public static class DocumentEdition implements java.io.Serializable {

		private String document = "";
		private String accessToken = "";

		public String document() {
			return this.document;
		}

		public String accessToken() {
			return this.accessToken;
		}

		public DocumentEdition document(String document) {
			this.document = document;
			return this;
		}

		public DocumentEdition accessToken(String accessToken) {
			this.accessToken = accessToken;
			return this;
		}

	}
}