package io.intino.amidas;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.net.URL;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.konos.alexandria.schema.Resource;
import io.intino.konos.restful.core.RestfulAccessor;
import io.intino.konos.restful.exceptions.RestfulFailure;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static org.slf4j.Logger.ROOT_LOGGER_NAME;


import io.intino.amidas.schemas.*;

public class AmidasTaskAccessor {
	private static Logger logger = LoggerFactory.getLogger(ROOT_LOGGER_NAME);

	private URL url;
	private static Gson gsonReader = gsonReader();
	private static Gson gsonWriter = gsonWriter();
	private RestfulAccessor accessor = new RestfulAccessor();

	public AmidasTaskAccessor(URL url) {
		this.url = url;
	}

	public String putRequestForEdition(String token, RequestProperties properties, RequestPolicy policy, String editor, String document, io.intino.konos.alexandria.schema.Resource preview) throws BadRequest, Conflict, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);
				if (properties != null) put("properties", encode(String.valueOf(gsonWriter.toJson(properties))));
				if (policy != null) put("policy", encode(String.valueOf(gsonWriter.toJson(policy))));
				if (editor != null) put("editor", editor);
				if (document != null) put("document", document);

			}};
			return String.valueOf(accessor.put(this.url, "/api" + "/task" + "/request" + "/edition", parameters, Arrays.asList(preview)).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("409")) throw new Conflict(e.label());
			throw new Unknown(e.label());
		}
	}

	public String putRequestForDecision(String token, RequestProperties properties, RequestPolicy policy, List<DecisionOption> options, String document, io.intino.konos.alexandria.schema.Resource preview) throws BadRequest, Conflict, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);
				if (properties != null) put("properties", encode(String.valueOf(gsonWriter.toJson(properties))));
				if (policy != null) put("policy", encode(String.valueOf(gsonWriter.toJson(policy))));
				if (options != null) put("options", encode(String.valueOf(gsonWriter.toJson(options))));
				if (document != null) put("document", document);

			}};
			return String.valueOf(accessor.put(this.url, "/api" + "/task" + "/request" + "/decision", parameters, Arrays.asList(preview)).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("409")) throw new Conflict(e.label());
			throw new Unknown(e.label());
		}
	}

	public String putRequestForDocumentSignature(String token, RequestProperties properties, RequestPolicy policy, String type, String format, io.intino.konos.alexandria.schema.Resource signature, io.intino.konos.alexandria.schema.Resource document, io.intino.konos.alexandria.schema.Resource preview) throws BadRequest, Conflict, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);
				if (properties != null) put("properties", encode(String.valueOf(gsonWriter.toJson(properties))));
				if (policy != null) put("policy", encode(String.valueOf(gsonWriter.toJson(policy))));
				if (type != null) put("type", type);
				if (format != null) put("format", format);



			}};
			return String.valueOf(accessor.put(this.url, "/api" + "/task" + "/request" + "/document" + "/signature", parameters, Arrays.asList(signature,document,preview)).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("409")) throw new Conflict(e.label());
			throw new Unknown(e.label());
		}
	}

	public String putRequestForDocumentEdition(String token, RequestProperties properties, RequestPolicy policy, io.intino.konos.alexandria.schema.Resource document, io.intino.konos.alexandria.schema.Resource preview, String mode) throws BadRequest, Conflict, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);
				if (properties != null) put("properties", encode(String.valueOf(gsonWriter.toJson(properties))));
				if (policy != null) put("policy", encode(String.valueOf(gsonWriter.toJson(policy))));


				if (mode != null) put("mode", mode);
			}};
			return String.valueOf(accessor.put(this.url, "/api" + "/task" + "/request" + "/document" + "/edition", parameters, Arrays.asList(document,preview)).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("409")) throw new Conflict(e.label());
			throw new Unknown(e.label());
		}
	}

	public io.intino.konos.alexandria.schema.Resource getTaskDocument(String token, String task) throws BadRequest, NotFound, Conflict, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);

			}};
			return accessor.getResource(this.url, "/api" + "/task" + "/" + task + "/document", parameters);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("404")) throw new NotFound(e.label());
			else if (e.code().equals("409")) throw new Conflict(e.label());
			throw new Unknown(e.label());
		}
	}

	public Boolean postTaskDocument(String token, String task, io.intino.konos.alexandria.schema.Resource document, Boolean completed) throws BadRequest, NotFound, Conflict, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);


				if (completed != null) put("completed", String.valueOf(completed));
			}};
			return Boolean.valueOf(accessor.post(this.url, "/api" + "/task" + "/" + task + "/document", parameters, Arrays.asList(document)).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("404")) throw new NotFound(e.label());
			else if (e.code().equals("409")) throw new Conflict(e.label());
			throw new Unknown(e.label());
		}
	}

	public Boolean postRejectTask(String token, String task, String reason) throws NotFound, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);


			}};
			return Boolean.valueOf(accessor.post(this.url, "/api" + "/task" + "/" + task + "/reject", parameters).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("404")) throw new NotFound(e.label());
			throw new Unknown(e.label());
		}
	}

	public Boolean postCompleteTask(String token, String task) throws BadRequest, NotFound, Conflict, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (token != null) put("token", token);

			}};
			return Boolean.valueOf(accessor.post(this.url, "/api" + "/task" + "/" + task + "/complete", parameters).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("404")) throw new NotFound(e.label());
			else if (e.code().equals("409")) throw new Conflict(e.label());
			throw new Unknown(e.label());
		}
	}

	private String encode(String value) {
		try {
			return java.net.URLEncoder.encode(value, "UTF-8");
		} catch (java.io.UnsupportedEncodingException e) {
			logger.error(e.getMessage(), e);
			return "";
		}
	}

	private static Gson gsonReader() {
        return new GsonBuilder().
            registerTypeAdapter(java.time.Instant.class, (com.google.gson.JsonDeserializer<java.time.Instant>) (json, type1, jsonDeserializationContext) -> java.time.Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).
            registerTypeAdapter(java.util.Date.class, (com.google.gson.JsonDeserializer<java.util.Date>) (json, type1, jsonDeserializationContext) -> new java.util.Date(json.getAsJsonPrimitive().getAsLong())).
            create();
	}

	private static Gson gsonWriter() {
        return new GsonBuilder().
            registerTypeAdapter(java.time.Instant.class, (com.google.gson.JsonSerializer<java.time.Instant>) (instant, type, context) -> new com.google.gson.JsonPrimitive(instant.toEpochMilli())).
            registerTypeAdapter(java.util.Date.class, (com.google.gson.JsonSerializer<java.util.Date>) (date, type, context) -> new com.google.gson.JsonPrimitive(date.getTime())).
            create();
    }
}