/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.box;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.restaccessor.OutBox;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.amidas.box.schemas.TokenInfo;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class TokensAccessor {
    private final URL url;
    private final RestAccessorNotifier notifier = new RestAccessorNotifier();
    private int timeoutMillis = 120000;
    private OutBox outBox = null;
    private Map<String, String> additionalHeaders = new HashMap<String, String>();
    private final String token;

    public TokensAccessor(URL url, String token) {
        this.url = url;
        this.token = token;
    }

    public TokensAccessor(URL url, int timeoutMillis, String token) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.token = token;
    }

    public TokensAccessor(URL url, int timeoutMillis, File outBoxDirectory, int intervalRetrySeconds, String token) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.outBox = new OutBox(outBoxDirectory, intervalRetrySeconds);
        this.token = token;
    }

    public void addCommonHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void addRequestSerializer(Type type, JsonSerializer<?> adapter) {
        RequestAdapter.addCustomAdapter((Type)type, adapter);
    }

    public void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {
        ResponseAdapter.addCustomAdapter((Type)type, adapter);
    }

    public String getToken(String user) throws BadRequest, NotFound, Unauthorized, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.bearerAuth(this.token).queryParameter("user", (Object)user).build(RequestBuilder.Method.GET, "/tokens");
        try {
            Response response = request.execute();
            return (String)ResponseAdapter.adapt((String)response.content(), String.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (e instanceof NotFound) {
                throw (NotFound)e;
            }
            if (e instanceof Unauthorized) {
                throw (Unauthorized)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public String postToken(String user) throws NotFound, Unauthorized, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.bearerAuth(this.token).queryParameter("user", (Object)user).build(RequestBuilder.Method.POST, "/tokens");
        try {
            Response response = request.execute();
            return (String)ResponseAdapter.adapt((String)response.content(), String.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof NotFound) {
                throw (NotFound)e;
            }
            if (e instanceof Unauthorized) {
                throw (Unauthorized)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public TokenInfo getTokenInfo(String token) throws BadRequest, NotFound, Unauthorized, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.bearerAuth(this.token).build(RequestBuilder.Method.GET, "/tokens/" + token);
        try {
            Response response = request.execute();
            return (TokenInfo)ResponseAdapter.adapt((String)response.content(), TokenInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (e instanceof NotFound) {
                throw (NotFound)e;
            }
            if (e instanceof Unauthorized) {
                throw (Unauthorized)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }
}

