/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.box;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.restaccessor.OutBox;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.amidas.box.schemas.Parameter;
import io.intino.amidas.box.schemas.UserInfo;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetupAccessor {
    private final URL url;
    private final RestAccessorNotifier notifier = new RestAccessorNotifier();
    private int timeoutMillis = 120000;
    private OutBox outBox = null;
    private Map<String, String> additionalHeaders = new HashMap<String, String>();

    public SetupAccessor(URL url) {
        this.url = url;
    }

    public SetupAccessor(URL url, int timeoutMillis) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
    }

    public SetupAccessor(URL url, int timeoutMillis, File outBoxDirectory, int intervalRetrySeconds) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.outBox = new OutBox(outBoxDirectory, intervalRetrySeconds);
    }

    public void addCommonHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void addRequestSerializer(Type type, JsonSerializer<?> adapter) {
        RequestAdapter.addCustomAdapter((Type)type, adapter);
    }

    public void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {
        ResponseAdapter.addCustomAdapter((Type)type, adapter);
    }

    public Boolean getPing() throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.GET, "/setup/ping");
        try {
            Response response = request.execute();
            return (Boolean)ResponseAdapter.adapt((String)response.content(), Boolean.class);
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public UserInfo getUserInfo(String token) throws Unauthorized, Conflict, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.queryParameter("token", (Object)token).build(RequestBuilder.Method.GET, "/setup/user/info");
        try {
            Response response = request.execute();
            return (UserInfo)ResponseAdapter.adapt((String)response.content(), UserInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Unauthorized) {
                throw (Unauthorized)e;
            }
            if (e instanceof Conflict) {
                throw (Conflict)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public UserInfo postUserWithToken(String token) throws Unauthorized, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.POST, "/setup/user/with-token/" + token);
        try {
            Response response = request.execute();
            return (UserInfo)ResponseAdapter.adapt((String)response.content(), UserInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Unauthorized) {
                throw (Unauthorized)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public UserInfo postUserWithCredential(String authentication, List<Parameter> parameters) throws Unauthorized, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.queryParameter("authentication", (Object)authentication).queryParameter("parameters", parameters).build(RequestBuilder.Method.POST, "/setup/user/with-credential");
        try {
            Response response = request.execute();
            return (UserInfo)ResponseAdapter.adapt((String)response.content(), UserInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Unauthorized) {
                throw (Unauthorized)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }
}

